@extends('layouts.app')

@section('content')
    <section class="section">
        <div class="section-header">
            <h3 class="page__heading">Editar Temporada</h3>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">

                            @if($errors->any())
                                <div class="alert alert-dark alert-dismissible fade show" role="alert">
                                    <strong>Revise los campos ingresados</strong>
                                    @foreach($errors->all() as $error)
                                        <span class="badge badge-danger">{{ $error }}</span>
                                    @endforeach
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endif

                            {!! Form::model($season, ['method' => 'PATCH', 'route' => ['seasons.update', $season->id]]) !!}

                                <div class="form-group">
                                    <label>Temporada</label>
                                    <select name="number" required class="form-control">
                                        <option @if($season->number == 1) selected @endif value="1">1</option>
                                        <option @if($season->number == 2) selected @endif value="2">2</option>
                                        <option @if($season->number == 3) selected @endif value="3">3</option>
                                        <option @if($season->number == 4) selected @endif value="4">4</option>
                                        <option @if($season->number == 5) selected @endif value="5">5</option>
                                        <option @if($season->number == 6) selected @endif value="6">6</option>
                                        <option @if($season->number == 7) selected @endif value="7">7</option>
                                        <option @if($season->number == 8) selected @endif value="8">8</option>
                                        <option @if($season->number == 9) selected @endif value="8">9</option>
                                        <option @if($season->number == 10) selected @endif value="10">10</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Descripción</label>
                                    <input type="text" name="description" required class="form-control" value="{{ $season->description }}">
                                </div>

                                <div class="form-group">
                                    <label>Estado</label>
                                    <select name="status" required class="form-control">
                                        <option @if($season->status == 1) selected @endif value="1">Habilitado</option>
                                        <option @if($season->status == 0) selected @endif value="0">Deshabilitado</option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                </div>

                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection




